clear; clc
%% Plot the results obtained
addpath('../Plot/')

%% User input
% Environment temperature
T_init_array = [26];
% Driving cycle
cycle_array = ["UDDS"];%["BuildIn","UDDS"];
% Target battery temperature
T_target = 30; %°C
% Target cabin temperature
T_target_HVAC = 21; %°C
% Strategy
strategy_array = ["Reactive","AMPC"]; %["Reactive","PID","Pcomp100","Pcomp300","Pcomp500","Pcomp1000"];

%% Compare different simulations
for T_init = T_init_array 
    for cycle = cycle_array
        for strategy = strategy_array
            file_name = append('Results/simlog_',strategy,'_Tenv',string(T_init),'_',cycle);
            try
                load(file_name);
                plot_prof(time,battery,EPowers,ElectricEnergy)
            catch 
                warning(append('The simulation for ','simlog_',strategy,'_Tenv',string(T_init),'_THVACtarget',string(T_target_HVAC),'_',cycle,...
                    ' was not completed'))
            end
        end
    end
end

%% Concatenate different simulations
% count = 1;
% for T_init = T_init_array 
%     for cycle = cycle_array
%         for strategy = strategy_array
%             try
%                 res = load(append('Results/simlog_',strategy,'_Tenv',string(T_init),'_THVACtarget',string(T_target_HVAC),'_',cycle));
%                 if count == 1
%                         res_concat = res;
%                 else
%                 % Loop through each structure in the current .mat file
%                 structNames = fieldnames(res); % Get all structure names in the .mat file
%                     for j = 1:length(structNames)
%                         currentStruct = res.(structNames{j});
%                         if isstruct(currentStruct)
%                             fields_names = fieldnames(currentStruct);
%                             for field_num = 1:length(fields_names)
%                                 field = fields_names{field_num};
%                                 res_concat.(structNames{j}).(field) = [res_concat.(structNames{j}).(field); res.(structNames{j}).(field)];
%                             end
%                         else
%                             res_concat.(structNames{j}) = [res_concat.(structNames{j}); res.(structNames{j})];
%                         end
%                     end
%                 end
%                 count = count+1;
%             catch 
%                 warning(append('The simulation for ','simlog_',strategy,'_Tenv',string(T_init),'_THVACtarget',string(T_target_HVAC),'_',cycle,...
%                     ' was not completed'))
%             end
%         end
%     end
% end
% 
% 
% 
% 
% plot_prof(res_concat.time,res_concat.battery,res_concat.EPowers,res_concat.ElectricEnergy,res_concat.cabin)

